/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.filedata;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.filedata.helper.ImageHelper;
import wjhk.jupload2.filedata.helper.ImageReaderWriterHelper;
import wjhk.jupload2.policies.PictureUploadPolicy;
import wjhk.jupload2.policies.UploadPolicy;

public class PictureFileData
extends DefaultFileData {
    private boolean isPicture = false;
    private Image offscreenImage = null;
    int quarterRotation = 0;
    int originalWidth = -1;
    int originalHeight = -1;
    private File transformedPictureFile = null;
    private long uploadLength = -1L;
    private File workingCopyTempFile = null;
    private String targetPictureFormat;

    public PictureFileData(File file, File root, PictureUploadPolicy uploadPolicy) throws JUploadIOException {
        super(file, root, uploadPolicy);
        String fileExtension = this.getFileExtension();
        this.isPicture = PictureFileData.isFileAPictrue(file);
        uploadPolicy.displayDebug("isPicture=" + this.isPicture + " (" + file.getName() + "), extension=" + fileExtension, 50);
        if (this.isPicture) {
            this.setMimeTypeByExtension(fileExtension);
        }
    }

    public static void freeMemory(String caller, UploadPolicy uploadPolicy) {
        Runtime rt = Runtime.getRuntime();
        rt.runFinalization();
        rt.gc();
        if (uploadPolicy.getDebugLevel() >= 50) {
            uploadPolicy.displayDebug("freeMemory (after " + caller + ") : " + rt.freeMemory() + " (maxMemory: " + rt.maxMemory() + ", totalMemory: " + rt.totalMemory() + ")", 50);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeUpload() throws JUploadException {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.beforeUpload()", 95);
        if (this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is already prepared for upload");
        }
        if (this.uploadLength < 0L) {
            try {
                PictureFileData.freeMemory("Picture manabeforeUpload(): before initTransformedPictureFile", this.uploadPolicy);
                this.initTransformedPictureFile();
                this.uploadPolicy.displayDebug(this.getClass().getName() + ".beforeUpload(): after call to initTransformedPictureFile()", 100);
            }
            catch (OutOfMemoryError e) {
                this.uploadPolicy.displayDebug(this.getClass().getName() + ".beforeUpload(): OutOfMemoryError", 30);
                this.deleteTransformedPictureFile();
                this.deleteWorkingCopyPictureFile();
                PictureFileData.freeMemory("beforeUpload(): in OutOfMemoryError", this.uploadPolicy);
                this.tooBigPicture();
            }
            PictureFileData pictureFileData = this;
            synchronized (pictureFileData) {
                if (this.transformedPictureFile != null) {
                    this.uploadLength = this.transformedPictureFile.length();
                    this.setMimeTypeByExtension(this.targetPictureFormat);
                } else {
                    this.uploadLength = this.getFile().length();
                }
            }
        }
        this.uploadPolicy.displayDebug(this.getClass().getName() + ".beforeUpload(): before call to super.beforeUpload()", 100);
        super.beforeUpload();
        this.uploadPolicy.displayDebug(this.getClass().getName() + ".beforeUpload(): after call to super.beforeUpload()", 100);
    }

    public long getUploadLength() throws JUploadException {
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        return this.uploadLength;
    }

    public synchronized InputStream getInputStream() throws JUploadException {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.getInputStream()", 95);
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        if (this.transformedPictureFile != null) {
            try {
                return new FileInputStream(this.transformedPictureFile);
            }
            catch (FileNotFoundException e) {
                throw new JUploadIOException(e);
            }
        }
        return super.getInputStream();
    }

    public void afterUpload() {
        this.deleteTransformedPictureFile();
        this.deleteWorkingCopyPictureFile();
        this.uploadLength = -1L;
        super.afterUpload();
    }

    public Image getImage(Canvas canvas, boolean shadow) throws JUploadException {
        Image localImage = null;
        if (canvas == null) {
            throw new JUploadException("canvas null in PictureFileData.getImage");
        }
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        if (canvasWidth <= 0 || canvasHeight <= 0) {
            this.uploadPolicy.displayDebug("canvas width and/or height null in PictureFileData.getImage()", 1);
        } else if (shadow && this.offscreenImage != null) {
            localImage = this.offscreenImage;
        } else if (this.isPicture) {
            try {
                ImageReaderWriterHelper irwh = new ImageReaderWriterHelper((PictureUploadPolicy)this.uploadPolicy, this);
                BufferedImage sourceImage = irwh.readImage(0);
                irwh.dispose();
                irwh = null;
                ImageHelper ih = new ImageHelper((PictureUploadPolicy)this.uploadPolicy, this, canvasWidth, canvasHeight, this.quarterRotation);
                localImage = ih.getBufferedImage(((PictureUploadPolicy)this.uploadPolicy).getHighQualityPreview(), sourceImage);
                sourceImage.flush();
                sourceImage = null;
            }
            catch (OutOfMemoryError e) {
                localImage = null;
                this.tooBigPicture();
            }
        }
        if (shadow) {
            this.offscreenImage = localImage;
        }
        PictureFileData.freeMemory("end of " + this.getClass().getName() + ".getImage()", this.uploadPolicy);
        this.uploadPolicy.getContext().getUploadPanel().getPreparationProgressBar().setValue(0);
        return localImage;
    }

    public void addRotation(int quarter) {
        this.quarterRotation += quarter;
        this.deleteWorkingCopyPictureFile();
        this.deleteTransformedPictureFile();
        this.uploadLength = -1L;
        while (this.quarterRotation < 0) {
            this.quarterRotation += 4;
        }
        while (this.quarterRotation >= 4) {
            this.quarterRotation -= 4;
        }
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
    }

    public boolean isPicture() {
        return this.isPicture;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public synchronized void deleteTransformedPictureFile() {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.deleteTransformedPictureFile()", 95);
        if (null != this.transformedPictureFile && this.uploadPolicy.getDebugLevel() <= 100) {
            if (!this.transformedPictureFile.delete()) {
                this.uploadPolicy.displayWarn("Unable to delete " + this.transformedPictureFile.getName());
            }
            this.transformedPictureFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTransformedPictureFile() throws JUploadException {
        int targetMaxHeight;
        int targetMaxWidth;
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.initTransformedPictureFile()", 95);
        if (this.quarterRotation == 0) {
            targetMaxWidth = ((PictureUploadPolicy)this.uploadPolicy).getMaxWidth();
            targetMaxHeight = ((PictureUploadPolicy)this.uploadPolicy).getMaxHeight();
        } else {
            targetMaxWidth = ((PictureUploadPolicy)this.uploadPolicy).getRealMaxWidth();
            targetMaxHeight = ((PictureUploadPolicy)this.uploadPolicy).getRealMaxHeight();
        }
        ImageHelper imageHelper = new ImageHelper((PictureUploadPolicy)this.uploadPolicy, this, targetMaxWidth, targetMaxHeight, this.quarterRotation);
        PictureFileData pictureFileData = this;
        synchronized (pictureFileData) {
            if (imageHelper.hasToTransformPicture() && this.transformedPictureFile == null) {
                try {
                    this.createTranformedPictureFile(imageHelper);
                }
                catch (JUploadException e) {
                    this.deleteTransformedPictureFile();
                    throw e;
                }
            }
        }
    }

    synchronized void createTranformedPictureFile(ImageHelper imageHelper) throws JUploadException {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.createTransformedPictureFile()", 95);
        IIOMetadata metadata = null;
        IIOImage iioImage = null;
        BufferedImage originalImage = null;
        BufferedImage transformedImage = null;
        ImageReaderWriterHelper imageWriterHelper = new ImageReaderWriterHelper((PictureUploadPolicy)this.uploadPolicy, this);
        boolean transmitMetadata = ((PictureUploadPolicy)this.uploadPolicy).getPictureTransmitMetadata();
        this.createTransformedTempFile();
        this.targetPictureFormat = imageWriterHelper.getTargetPictureFormat();
        imageWriterHelper.setOutput(this.transformedPictureFile);
        int nbPictures = 1;
        if (PictureFileData.getExtension(this.getFile()).equalsIgnoreCase("gif")) {
            nbPictures = Integer.MAX_VALUE;
        }
        this.uploadPolicy.displayDebug("Reading image with imageWriterHelper.readImage(i)", 50);
        try {
            for (int i = 0; i < nbPictures; ++i) {
                originalImage = imageWriterHelper.readImage(i);
                transformedImage = imageHelper.getBufferedImage(true, originalImage);
                if (transmitMetadata) {
                    metadata = imageWriterHelper.getImageMetadata(i);
                }
                iioImage = new IIOImage(transformedImage, null, metadata);
                imageWriterHelper.write(iioImage);
                if (originalImage == null) continue;
                originalImage.flush();
                originalImage = null;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.uploadPolicy.displayDebug("IndexOutOfBoundsException catched: end of reading for file " + this.getFileName(), 10);
        }
        if (originalImage != null) {
            originalImage.flush();
            originalImage = null;
        }
        imageWriterHelper.dispose();
    }

    private void tooBigPicture() {
        String msg = String.format(this.uploadPolicy.getString("tooBigPicture"), this.getFileName());
        this.uploadPolicy.displayWarn(msg);
        JOptionPane.showMessageDialog(null, msg, "Warning", 2);
    }

    private void setMimeTypeByExtension(String fileExtension) {
        String ext = fileExtension.toLowerCase();
        if (ext.equals("jpg")) {
            ext = "jpeg";
        }
        this.mimeType = "image/" + ext;
    }

    private synchronized void createTransformedTempFile() throws JUploadIOException {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.createTransformedTempFile()", 95);
        if (this.transformedPictureFile == null) {
            try {
                this.transformedPictureFile = File.createTempFile("jupload_", ".tmp");
            }
            catch (IOException e) {
                throw new JUploadIOException("PictureFileData.createTransformedTempFile()", e);
            }
            this.uploadPolicy.getContext().registerUnload(this, "deleteTransformedPictureFile");
            this.uploadPolicy.displayDebug("Using transformed temp file " + this.transformedPictureFile.getAbsolutePath() + " for " + this.getFileName(), 30);
        }
    }

    private void initWidthAndHeight() throws JUploadIOException {
        Iterator<ImageReader> iter;
        if (this.isPicture && (this.originalHeight < 0 || this.originalWidth < 0) && (iter = ImageIO.getImageReadersByFormatName(this.getFileExtension().toLowerCase())).hasNext()) {
            try {
                FileImageInputStream fiis = new FileImageInputStream(this.getFile());
                ImageReader ir = iter.next();
                ir.setInput(fiis);
                this.originalHeight = ir.getHeight(0);
                this.originalWidth = ir.getWidth(0);
                ir.dispose();
                fiis.close();
            }
            catch (IOException e) {
                throw new JUploadIOException("PictureFileData()", e);
            }
        }
    }

    private synchronized void createWorkingCopyTempFile() throws IOException {
        this.uploadPolicy.displayDebug(this.hashCode() + "|Entering PictureFileData.createWorkingCopyTempFile()", 95);
        if (this.workingCopyTempFile == null) {
            this.workingCopyTempFile = File.createTempFile("jupload_", ".tmp." + DefaultFileData.getExtension(this.getFile()));
            this.uploadPolicy.getContext().registerUnload(this, "deleteWorkingCopyPictureFile");
            this.uploadPolicy.displayDebug("Using working copy temp file " + this.workingCopyTempFile.getAbsolutePath() + " for " + this.getFileName(), 30);
        }
    }

    public synchronized void deleteWorkingCopyPictureFile() {
        if (null != this.workingCopyTempFile && this.uploadPolicy.getDebugLevel() <= 100) {
            if (!this.workingCopyTempFile.delete()) {
                this.uploadPolicy.displayWarn("Unable to delete " + this.workingCopyTempFile.getName());
            }
            this.workingCopyTempFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized File getWorkingSourceFile() throws JUploadIOException {
        if (this.workingCopyTempFile != null) return this.workingCopyTempFile;
        this.uploadPolicy.displayDebug("[getWorkingSourceFile] Creating a copy of " + this.getFileName() + " as a source working target.", 30);
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            IOException e32;
            block18: {
                try {
                    int l;
                    this.createWorkingCopyTempFile();
                    is = new FileInputStream(this.getFile());
                    os = new FileOutputStream(this.workingCopyTempFile);
                    byte[] b = new byte[1024];
                    while ((l = is.read(b)) > 0) {
                        os.write(b, 0, l);
                    }
                    Object var6_6 = null;
                    if (is == null) break block18;
                }
                catch (IOException e2) {
                    throw new JUploadIOException("ImageReaderWriterHelper.getWorkingSourceFile()", e2);
                }
                try {
                    try {
                        is.close();
                    }
                    catch (IOException e32) {
                        this.uploadPolicy.displayWarn(e32.getClass().getName() + " while trying to close FileInputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                        Object var9_9 = null;
                        is = null;
                        break block18;
                    }
                    Object var9_8 = null;
                    is = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    is = null;
                    throw throwable;
                }
            }
            if (os == null) return this.workingCopyTempFile;
            try {
                try {
                    os.close();
                }
                catch (IOException e32) {
                    this.uploadPolicy.displayWarn(e32.getClass().getName() + " while trying to close FileOutputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                    return this.workingCopyTempFile;
                }
                return this.workingCopyTempFile;
            }
            catch (Throwable throwable) {
                Object var11_20 = null;
                os = null;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            IOException e32;
            block19: {
                Object var6_7 = null;
                if (is != null) {
                    try {}
                    catch (Throwable throwable2) {
                        Object var9_13 = null;
                        is = null;
                        throw throwable2;
                    }
                    try {}
                    catch (IOException e32) {
                        this.uploadPolicy.displayWarn(e32.getClass().getName() + " while trying to close FileInputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                        Object var9_12 = null;
                        is = null;
                        break block19;
                    }
                    is.close();
                    Object var9_11 = null;
                    is = null;
                }
            }
            if (os == null) throw throwable;
            try {}
            catch (Throwable throwable3) {
                Object var11_23 = null;
                os = null;
                throw throwable3;
            }
            try {}
            catch (IOException e32) {
                this.uploadPolicy.displayWarn(e32.getClass().getName() + " while trying to close FileOutputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                Object var11_22 = null;
                os = null;
                throw throwable;
            }
            os.close();
            Object var11_21 = null;
            os = null;
            throw throwable;
        }
    }

    public int getOriginalWidth() throws JUploadIOException {
        this.initWidthAndHeight();
        return this.originalWidth;
    }

    public int getOriginalHeight() throws JUploadIOException {
        this.initWidthAndHeight();
        return this.originalHeight;
    }

    public static ImageIcon getImageIcon(File pictureFile, int maxWidth, int maxHeight) {
        ImageIcon tmpIcon;
        ImageIcon thumbnail = null;
        if (pictureFile != null && (tmpIcon = new ImageIcon(pictureFile.getPath())) != null) {
            double scaleHeight;
            double scaleWidth = (double)maxWidth / (double)tmpIcon.getIconWidth();
            double scale = Math.min(scaleWidth, scaleHeight = (double)maxHeight / (double)tmpIcon.getIconHeight());
            thumbnail = scale < 1.0 ? new ImageIcon(tmpIcon.getImage().getScaledInstance((int)(scale * (double)tmpIcon.getIconWidth()), (int)(scale * (double)tmpIcon.getIconHeight()), 2)) : tmpIcon;
        }
        return thumbnail;
    }

    public static boolean isFileAPictrue(File file) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName(DefaultFileData.getExtension(file).toLowerCase());
        return iter.hasNext();
    }
}

