<?php

// (c) Stephan Slabihoud
// plugin for AdsManager

global $mainframe;
if(method_exists($mainframe,'registerEvent')){
	defined( '_JEXEC' ) or die( 'Restricted access' );
	$mainframe->registerEvent( 'onSendPMS', 'botUddeimPlugAdsManager' );
}else{
	defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
	$_MAMBOTS->registerFunction('onSendPMS', 'botUddeimPlugAdsManager');
}

class UddeimPlugAdsManager {
	var $config;

	function UddeimPlugAdsManager() {
		global $mainframe;
		if(file_exists( $mainframe->getCfg('absolute_path') . "/administrator/components/com_uddeim/config.class.php")) {
			include_once( $mainframe->getCfg('absolute_path') . "/administrator/components/com_uddeim/config.class.php");
		}
		$this->config = new uddeimconfigclass();
	}

	function _checkPMSinstalled() {
		global $mainframe;
		if (!file_exists($mainframe->getCfg('absolute_path').'/components/com_uddeim/uddeim.php')) {
			return false;
		}
		return true;
	}

	function _sendPMSuddeimMSG($udde_toid,$udde_fromid,$to,$from,$sub,$msg) {
		global $database, $mainframe; 
		
		if($sub) {
			$udde_msg = "[b]".$sub."[/b]\n\n".$msg;
		} else {
			$udde_msg = $msg;
		}
		$udde_msg = strip_tags($udde_msg);
		$cm = $udde_msg;
		
		$currentTime=time();
		$udde_time=$this->_pmsUddeGetTime($currentTime);
		
		if($udde_fromid && $udde_toid) {
			$sql="INSERT INTO #__uddeim (fromid, toid, message, datum) VALUES (".$udde_fromid.", ".$udde_toid.", '".$cm."', ".$udde_time.")";
			$database->SetQuery($sql);
			if (!$database->query()) {
				die("SQL error" . $database->stderr(true));
			}
			$this->_pmsUddeNotify($udde_fromid, $udde_toid, $udde_msg, "");
		}
	}
	
	function sendUserPMS($toid, $fromid, $subject, $message, $systemGenerated=false, $escaped=false) {
		global $database;

		$toid	= (int) $toid;
		$fromid	= (int) $fromid;

		if (!$this->_checkPMSinstalled() || !$fromid || !$toid) {
			return false;
		}

		if (!$escaped) {
			$subject = $database->getEscaped($subject);
			$message = $database->getEscaped($message);
		}

		$rowFrom = new mosUser( $database );
		$rowFrom->load( (int) $fromid );
		$from = $rowFrom->username;
		
		$rowTo = new mosUser( $database );
		$rowTo->load( (int) $toid );	
		$to=$rowTo->username;
		
		$this->_sendPMSuddeimMSG($toid,$fromid,$to,$from,$subject,$message);				
		return true;
	}

	function _pmsUddeNotify($savefromid, $savetoid, $savemessage, $udde_sysm) {
		global $database, $mainframe;
		
		if ($this->config->notifydefault>0 || $this->config->popupdefault>0) {
			$sql="SELECT count(id) FROM #__uddeim_emn WHERE userid=".(int)$savetoid;
			$database->setQuery($sql);
			$entryexists=$database->loadResult();
			if (!$entryexists) {
				$sql="INSERT INTO #__uddeim_emn (status, popup, userid) VALUES (".(int)$this->config->notifydefault.", ".(int)$this->config->popupdefault.", ".(int)$savetoid.")";
				$database->setQuery($sql);
				$ret=$database->query();
			}
		}

		$itisareply = (isset($this->config->quotedivider) ? stristr($savemessage, $this->config->quotedivider) : false);

		$sql="SELECT userid FROM #__session WHERE userid=".(int) $savetoid;
		$database->setQuery($sql);
		$currentlyonline=$database->loadResult();
		
		if ($this->config->allowemailnotify==1) {
			$sql="SELECT status FROM #__uddeim_emn WHERE userid=".(int) $savetoid;
			$database->setQuery($sql);
			$ison=$database->loadResult();
			if (($ison==1) || ($ison==2 && !$currentlyonline) || ($ison==10 && !$itisareply) || ($ison==20 && !$currentlyonline && !$itisareply))  {
				$this->_pmsUddeDispatchEMN($savefromid, $savetoid, $savemessage, 0, $udde_sysm); // 0 stands for normal (not forgetmenot)
			}
		} elseif ($this->config->allowemailnotify==2) {
			$sql="SELECT gid FROM #__users WHERE id=".(int) $savetoid;
			$database->setQuery($sql);
			$my_gid=$database->loadResult();
			if ($my_gid==24||$my_gid==25) {
				$sql="SELECT status FROM #__uddeim_emn WHERE userid=".(int) $savetoid;
				$database->setQuery($sql);
				$ison=$database->loadResult();
				if (($ison==1) || ($ison==2 && !$currentlyonline) || ($ison==10 && !$itisareply) || ($ison==20 && !$currentlyonline && !$itisareply))  {
					$this->_pmsUddeDispatchEMN($savefromid, $savetoid, $savemessage, 0, $udde_sysm);  // 0 stands for normal (not forgetmenot)
				} 	
			}	
		}
	}
	
	function _pmsUddeDispatchEMN($var_fromid, $var_toid, $var_message, $emn_option, $udde_sysm) {
		global $database, $mosConfig_lang, $mosConfig_sitename, $mainframe;
		
		$adminpath = $mainframe->getCfg('absolute_path') . "/administrator/components/com_uddeim";

		$postfix = "";
		if ($this->config->languagecharset)
			$postfix = ".utf8";
		if (file_exists($adminpath.'/language'.$postfix.'/'.$mosConfig_lang.'.php')) {
			include_once($adminpath.'/language'.$postfix.'/'.$mosConfig_lang.'.php');
		} elseif (file_exists($adminpath.'/language'.$postfix.'/english.php')) {
			include_once($adminpath.'/language'.$postfix.'/english.php');
		} elseif (file_exists($adminpath.'/language/english.php')) {
			include_once($adminpath.'/language/english.php');
		}

		if (isset($this->config->emailtrafficenabled) && !($this->config->emailtrafficenabled > 0)) {
			return;
		}
		
		$sql = "SELECT ".($this->config->realnames ? "name" : "username")." FROM #__users WHERE `id`=".(int) $var_fromid;
		$database->setQuery($sql);
		$var_fromname=$database->loadResult();
		if (!$var_fromname) {
			$var_fromname=$this->config->sysm_username;
		}
		
		$sql = "SELECT ".($this->config->realnames ? "name" : "username")." AS displayname, email FROM #__users WHERE `id`=".(int) $var_toid;	
		$database->setQuery($sql);
		$results=$database->loadObjectList();
		foreach ($results as $result) {
			$var_toname = $result->displayname;
			$var_tomail = $result->email;
		}
		
		if (!$var_tomail) {
			return;
		}
		
		if ($emn_option==1) {
			$var_body = _UDDEIM_EMN_FORGETMENOT;
			$var_body = str_replace("%you%", $var_toname, $var_body);
			$var_body = str_replace("%site%", $mosConfig_sitename, $var_body);
		} else {
			if ($this->config->emailwithmessage) {
				$var_body = _UDDEIM_EMN_BODY_WITHMESSAGE;
				$var_body = str_replace("%you%", $var_toname, $var_body);
				$var_body = str_replace("%site%", $mosConfig_sitename, $var_body);	
				$var_body = str_replace("%user%", $var_fromname, $var_body);
				$var_body = str_replace("%pmessage%", $var_message, $var_body);	
			} else {
				$var_body=_UDDEIM_EMN_BODY_NOMESSAGE;
				$var_body = str_replace("%you%", $var_toname, $var_body);
				$var_body = str_replace("%site%", $mosConfig_sitename, $var_body);		
				$var_body = str_replace("%user%", $var_fromname, $var_body);			
			}
		}
		
		$subject=_UDDEIM_EMN_SUBJECT;
		$subject=str_replace("%site%", $mosConfig_sitename, $subject);
		
		if (mosMail($this->config->emn_sendermail, $this->config->emn_sendername, $var_tomail,$subject,$this->_pmsMailcompatible($var_body))) {
			// set the remindersent status of this user to true
			$sql="SELECT count(id) FROM #__uddeim_emn WHERE userid=".(int) $var_toid;
			$database->setQuery($sql);
			$exists=$database->loadResult();
			if($exists) {
				$sql="UPDATE #__uddeim_emn SET remindersent=".(int) $this->_pmsUddeGetTime(time())." WHERE userid=".(int) $var_toid;
				$database->setQuery($sql);
				if (!$database->query()) {
					die("SQL error" . $database->stderr(true));
				}
			} else {
				$sql="INSERT INTO #__uddeim_emn (userid, status, remindersent) VALUES (".(int) $var_toid.", 0, ".(int) $this->_pmsUddeGetTime(time()).")";
				$database->setQuery($sql);
				if (!$database->query()) {
					die("SQL error" . $database->stderr(true));
				}
			}
		}
	}

	function _pmsMailcompatible($string) {
		$string = str_replace('\\n', '#!CRLF!#', $string);
		$string = stripslashes($string);
	    $string = preg_replace("/(\[b\])(.*?)(\[\/b\])/si","\\2",$string);
	    $string = preg_replace("/(\[u\])(.*?)(\[\/u\])/si","\\2",$string);
		$string = preg_replace("/(\[i\])(.*?)(\[\/i\])/si","\\2",$string);
		$string = preg_replace("/\[size=([1-7])\](.+?)\[\/size\]/si","\\2",$string);
		$string = preg_replace("%\[color=(.*?)\](.*?)\[/color\]%si","\\2",$string);
		$string = preg_replace("/(\[ul\])(.*?)(\[\/ul\])/si","\\2",$string);
		$string = preg_replace("/(\[ol\])(.*?)(\[\/ol\])/si","\\2",$string);
		$string = preg_replace("/(\[li\])(.*?)(\[\/li\])/si","\\2\\n",$string);
		$string = preg_replace('/\[url\](.*?)javascript(.*?)\[\/url\]/si','',$string);
		$string = preg_replace('/\[url=(.*?)javascript(.*?)\](.*?)\[\/url\]/si','',$string);
		$string = preg_replace("/\[url\](.*?)\[\/url\]/si","\\1",$string);
		$string = preg_replace("/\[url=(.*?)\](.*?)\[\/url\]/si","\\2 (\\1)",$string);	
		$string = preg_replace("/\[url=(.*?)\]/si","",$string);	
		$string = preg_replace("/\[img size=([0-9][0-9][0-9])\](.*?)\[\/img\]/si","",$string);
		$string = preg_replace("/\[img size=([0-9][0-9])\](.*?)\[\/img\]/si","",$string);
		$string = preg_replace("/\[img\](.*?)\[\/img\]/si","",$string);
		$string = preg_replace("/<img(.*?)javascript(.*?)>/si",'',$string);	
		$string = preg_replace("/\[img size=([0-9][0-9][0-9])\]]/si","",$string);
		$string = preg_replace("/\[img size=([0-9][0-9])\]]/si","",$string);
		$string = str_replace(array("[i]","[/i]","[b]","[/b]","[u]","[/u]","[ul]","[/ul]","[ol]","[/ol]","[li]","[/li]"), "", $string);
	    $string = preg_replace('/\[url=(.*?)javascript(.*?)\]/si','',$string);	
	    $string = preg_replace("/\[img size=([0-9][0-9][0-9])\]/si","",$string);
	    $string = preg_replace("/\[img size=([0-9][0-9])\]/si","",$string);
	    $string = preg_replace("/\[size=([1-7])\]/si","",$string);
	    $string = preg_replace("%\[color=(.*?)\]%si","",$string);
		$string = str_replace(array("[img]","[/img]","[url]","[/url]","[/color]","[/size]"), "", $string);
		$string = str_replace("#!CRLF!#", "\n", $string);	 
		return $string;
	}	

	function _pmsUddeGetTime($currentTime) {
		global $mosConfig_offset;
		return $currentTime+($mosConfig_offset*3600);
	}
}


if (!function_exists('botUddeimPlugAdsManager')) {
	function botUddeimPlugAdsManager($toid, $fromid, $subject, $message) {
		$class_botUddeimPlugAdsManager =& new UddeimPlugAdsManager();
		return $class_botUddeimPlugAdsManager->sendUserPMS($toid, $fromid, $subject, $message);
	}
}
